package fr.asip.cps3.exemple.modele.resultats;

/**
 * Classe reprsentant le rsultat de gnration d'empreinte d'un message court
 */
public class ResultatEmpreinteMessage extends ResultatDouble {

	/**
	 * L'empreinte
	 */
	private String empreinte;

	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 */
	public ResultatEmpreinteMessage(String operation1, String operation2){
		this(operation1, operation2, "");
	}
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param empreinte L'empreinte
	 */
	public ResultatEmpreinteMessage(String operation1, String operation2, String empreinte){
		super(operation1, operation2);
		this.empreinte = empreinte;
	}
	
	/**
	 * Accesseur
	 * @return L'empreinte
	 */
	public String getEmpreinte() {
		return this.empreinte;
	}

	/**
	 * Mutateur
	 * @param empreinte L'empreinte
	 */
	public void setEmpreinte(String empreinte) {
		this.empreinte = empreinte;
	}

}
